## 登陆页面

### **1.功能概述**

本界面为设备智能看护诊断系统登录入口，通过简洁的界面设计实现用户身份验证功能，确保设备操作与数据管理的安全性。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825654451251.png)

### **2.操作流程**

#### **2.1 访问系统**

显示器分辨率>=1920 \* 1080，且谷歌内核浏览器（版本>=92）访问：
工智机ip地址:20031（如：192.168.111.174:20031）

#### **2.2 身份验证**

步骤1：在「用户名」输入框填写工号/注册账号

步骤2：在「密码」输入框输入对应密码（密码默认隐藏显示）

步骤3：拖动蓝色滑块验证

步骤4：点击蓝色「登录」按钮


## 辅助功能（通用）

### **1.分页控制**

#### **1.1 分页容量**

可切换每页显示10条/20条/30条/40条信息
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825656047c6e.png)

#### **1.2 翻页操作**

点击「<」「>」按钮翻页
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825656a5eda5.png)

点击想要前往的页码进行跳转
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682565736e2ae.png)

输入想要跳转的页码进行跳转
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825657d12e5e.png)

### **2.筛选查询**

根据提示选择或输入筛选条件，点击「查询」按钮进行筛选，点击「重置」按钮清空筛选条件
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68256584d39a2.png)

机组看板页面独有「仅显示关注机组」，勾选后，仅显示关注机组（点击机组名称前星号，标蓝可进行关注）
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825658d4d833.png)

在左侧组织树选择或模糊搜索后，进行选择可显示对应组织及其下属组织机组
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68256597a5ed6.png)
### **3.数据刷新**
点击「刷新」按钮强制更新页面内容
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682565a3a933b.png)

### **4.语言切换**

点击上方的「Language」下拉框切换中英文
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682565b05f081.png)

## 智能看护大屏（首页）

### **1.功能概述**

使用智能看护大屏快速了解到当前看护机组的实时运行状态、实时健康等级、机组占比分布、主要故障分布、机组实时看板、实时预警通知、组织机组实时健康统计信息：
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682565bdd9375.png)

### **2.背景选择**

智能看护大屏支持用户更换背景图片，用户可通过点击右上角的「∨」，在下拉框中选择大屏主体区显示的背景图片。系统默认提供：陆地采油、钻井平台、冶金、火力发电、污水处理、炼化、能源开采背景图，用户可依据显示要求自行选择。选择后该组织所有用户均将使用该背景。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682565c93abb3.png)

### **3.背景上传**

智能看护大屏也支持用户自行上传背景图片。用户点击右上角的「∨」，选择下方的自定义按钮，弹出图片背景设置窗体，图片支持jpg、png格式，用户可上传10mb以下大小图片。上传后，该组织所有用户登陆后均使用该背景图片作为大屏背景图（上传的图片文件名不能包含特殊字符）
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682565d4aff99.png)
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682565e18bfeb.png)

### **4.机组看板**

点击右上方「🏠」可以进入到机组看板界面，并可由此进入其他详情界面
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682565ed5e6e8.png)

### **5.退出登录**

点击右上方「⏻」可退出登录
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682565f855482.png)

### **6.详情跳转**

点击以下四个部分可跳转至相应的详情界面
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825660501177.png)

## 智能机组看护

### **1.机组看板**

#### **1.1 功能概述**

使用该功能完成对已看管机组的统一看护。看板内可以查看机组所属组织及机组名称，并展示机组机构、当前健康等级、累计运行时长、此次运行时长、机组实时运行状态，AI版可查看到最新AI看护诊断结果。看板支持根据机组名称、健康等级、运行状态快速筛选。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e4e911277.png)

### **2.机组详情**

#### **2.1 导航路径**

「智能机组看护」→「机组看板」→「详情」
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e50a87da9.png)


#### **2.2 功能概述**

客户使用看板详情可以对指定机组进行全方位看护诊断。详情看板内，客户可以查看机组机构、测点安装示意位置。同时能够查看当前机组运行状态，AI版可查看最新AI看护诊断结果。

同时看板详情可实时呈现当前机组已经加装IOT硬件的实时数据。并在IOT硬件采集数据超出设定阈值后高亮显示。看板详情还可显示当前机组的近期及指定时间内的运行状态分布、健康等级分布，以及最新异常告警。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e51f51b05.png)


#### **2.3 详情看板**

**2.3.1 机组实时数据查看**

进入机组看板详情后，在详情看板下方可实时看到看护机组的最新特征数据，依据测点位置排列。各测点看板内，振动数据按照温度、测点Z轴、X轴、Y轴数据排列。并且数据可依据数据类型切换显示。当前数据类型可选择加速度、速度类型。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e52fb7d49.png)


当前各看板每页可显示4条数据，超过可点击「<」「>」按钮进行翻页
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e53c08af0.png)


下方会展示相应的趋势图，可进行放大缩小，鼠标悬置显示详细信息，选择测点位置可进行切换
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e545c97f9.png)


**2.3.2 实时运行状态查看**

进入机组看板详情后，在详情内的中间区域可查看到机组机构，并可实时查看到机组当前运行状态，以及最新AI诊断结论
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e54e70c69.png)



**2.3.3 看护诊断报告查看**

进入机组看板详情后，点击机组AI工况或轴承工况，可自动生成本次诊断报告，并自动下载PDF至本地
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e55ca1fb2.png)

![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e56ce3483.png)


**2.3.4 健康等级历史查看**

进入机组看板后，点击健康等级分布按钮进入健康等级历史查看页面。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e58a9c34e.png)


进入后选择指定日期，显示对应周期内的健康等级分布
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e594483a6.png)


**2.3.5 运行历史状态查看**

进入机组看板后，点击机组运行状态分布按钮进入运行历史状态查看页面。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e59e79489.png)


进入后选择指定日期，显示对应周期内的机组运行状态分布，也可点击图例选择信息显示
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e5ac2d836.png)


**2.3.6 最近异常信息**

进入机组看板详情后，在右下方“异常信息”出可查看机组最近发生的5条异常信息，包含异常类型、异常状态、发生时间。点击“查看更多”按钮可跳转至“异常管理”功能页面
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e5b7a5b8d.png)


**2.3.7 报警门限设置**

点击「报警门限设置」按钮，弹窗内设置门限值，当这些参数超过设定的门限值时，系统会发出告警。用户可以通过点击“确定”按钮来保存这些设置，或者点击“取消”按钮来放弃更改。&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e5c09f4da.png)


#### **2.4 诊断报告**

**2.4.1 诊断报告查看**

进入机组看板详情后，点击「诊断报告」按钮可跳转至该机组诊断报告。诊断报告内可查看用户人工上传的该机组报告，并可快速了解诊断结论
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e5cb7f032.png)


点击指定条目的「下载」即可将报告下载到用户本地。点击「删除」可将指定诊断报告删除
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e5d7f25fc.png)


**2.4.2 诊断报告上传**

进入诊断报告页面后，点击诊断报告上传按钮「报告上传」，弹出报告上传页面
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e5e23161f.png)


点击「确定」后即可完成报告上传。报告格式不限，但文件大小不允许超过10Mb，且只能上传一个文件。

#### **2.5 机组资料库**

进入机组看板详情后，点击「机组资料库」按钮可跳转至该机组资料库。资料库内可查看用户人工上传各类关于该机组的相关文件、图片信息
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e5eb51833.png)


对于图片，用户可在资料库右侧快速查看，点击指定图片便可预览其图片内容，点击「下载」可将图片下载至用户本地。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e5f7a56a4.png)


#### **2.6 机组诊断**

点击机组诊断后将跳转至「智能机组诊断」→「诊断试图」
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e6044e78e.png)
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e60e28be3.png)


### **3.机组管理**

#### **3.1 导航路径**

「智能机组看护」→「机组管理」
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825671b72da9.png)

#### **3.2 功能概述**

客户使用机组管理完成对管辖组织内的所有机组台账管理，查看指定机组的下辖所有设备的参数及信息。同一个组织下的各机组位号不允许重复
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825672556c16.png)

#### **3.3 机组添加**

进入机组管理后，点击右上方的「添加机组」按钮后弹出添加机组页面
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825753129750.png)


同一组织下的机组位号唯一，不允许重复。用户添加时，可自行上传当前添加机组的概貌图，概貌图将显示在机组看板、机组详情以及智慧大屏内。如用户未选择机组概貌图，系统将依据该机组的自类型自动分配。

#### **3.4 机组编辑**

进入机组管理后，点击指定机组的「编辑」按钮后弹出编辑机组页面
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825753cd1037.png)


机组编辑时，机组位号、机组所属组织、机组结构不允许进行编辑.用户编辑时，可自行上传当前添加机组的概貌图，概貌图将显示在机组看板、机组详情以及智慧大屏内。如用户未选择机组概貌图，系统将依据该机组的自类型自动分配。

#### **3.5 机组详情**

进入机组管理后，点击指定机组的「详情」按钮后右侧划出该机组下属所有设备的详情信息
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825754aa9f75.png)
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68257557aa1c0.png)

#### **3.6 报警门限设置**

点击「报警门限设置」按钮，弹窗内设置门限值，当这些参数超过设定的门限值时，系统会发出告警。用户可以通过点击“确定”按钮来保存这些设置，或者点击“取消”按钮来放弃更改。&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825756310005.png)

### **4.设备管理**

#### **4.1 导航路径**

「智能机组看护」→「设备管理」
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825756dafca7.png)

#### **4.2 功能概述**

客户使用设备管理对管辖组织内的所有设备台账管理，查看指定设备的参数信息。同一机组下的位置编号对应设备唯一
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825757bdb1cc.png)

#### **4.3 设备添加**

进入设备管理后，点击右上方的「添加设备」按钮后跳转至添加设备页面
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682575848f198.png)

选择指定组织后，自动带出对应机组，在选择设备类型后，下方铭牌显示该设备类型需填写的铭牌参数。对于一个机组，同一个机组位置序号仅能有一台设备。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825758bba6d3.png)


在轴承型号内输入型号关键字（至少3位）自动会显示目前支持的轴承型号（包含关键字内容的）
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825759686a14.png)

轴承型号支持多个选择
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682575a21e11c.png)

#### **4.4 设备编辑**

进入设备管理后，点击指定设备的「编辑」按钮后跳转至编辑设备页面，设备的所属组织、机组名称、位置序号、设备类型不允许修改。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682575acf0e9c.png)

#### **4.5 设备详情**

进入机组管理后，点击指定设备的「详情」按钮后右侧划出该设备的详情信息
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682575b8d3989.png)

## 智能机组诊断

### **1.诊断视图**

#### **1.1 导航路径**

「智能机组诊断」→「诊断视图」
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682575c48ece2.png)

#### **1.2 功能概述**

客户使用智能诊断视图可以对看护机组进行数据分析。诊断图谱提供加速度视图、速度视图、包络视图、倒谱视图、瀑布视图、单测点对比、多测点对比、特征趋势分析、运行趋势视图。视图内包含趋势图谱、波形图谱、频谱图谱。各图谱内支持快捷主游标设定、多游标快捷查看（两游标、三游标、五游标）、主辅游标差值查看、预警线查看等。趋势图内额外支持趋势点显示及隐藏。波形、谱图支持多点标注功能，可方便用户对同一图谱上的数据点位进行对比。各图谱均支持指定区域缩放及快速定位。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682575cf90105.png)

#### **1.3 波形、频谱显示**

进入后默认显示用户所管辖组织的默认第一个机组的第一个测点数据，显示时间为近7天。左键单击趋势图内数据点后，下方波形、频谱显示对应选择数据点信息
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682575d779be4.png)

同时趋势图注游标显示点击趋势点信息
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682575e14fbcd.png)

#### **1.4 主游标切换**

进入诊断视图后，点击图谱内的数据点，完成主游标切换，切换后主游标信息显示最新选择点信息
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682575ee235b4.png)
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682575f72d808.png)

#### **1.5 趋势图点位显示**

进入诊断视图后，点击趋势图右上方的点位显示按钮，点击后趋势图内的点位显示。再次点击后趋势图内的点位消失
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825761dcfae6.png)
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825762610e1c.png)

#### **1.6 预警线显示**

进入诊断视图后，点击趋势图右上方的预警线显示按钮，点击后趋势图内显示预警线，再次点击后隐藏预警线
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825762dc36ae.png)

手动输入预警线数值或使用按钮，可快速调节预警西安在趋势图上位置
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68257638611fa.png)

#### **1.7 辅游标显示**

进入诊断视图后，点击图谱右上方的辅游标显示按钮，点击后选择游标数量
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68257640f12e5.png)

选择指定游标数量后，辅游标功能开启，在图谱内右键点击数据点出现第二游标，如选择多游标，则第三、四、五游标根据主游标与第二游标间隔自动显示。同时游标信息内，辅游标显示第二游标点位数值，锁定差值为主游标与第二游标间差值。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825764a05dad.png)

点击辅游标显示按钮的关闭选项，则游标全部隐藏，游标信息内的辅游标、锁定差值清空
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825765358a0a.png)
#### **1.8 清空**

进入诊断视图后，点击图谱右上方的清空按钮，图谱恢复为默认加载状态
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825765ea975a.png)

#### **1.9 图谱下载**

进入诊断视图后，点击图谱右上方的下载按钮，图谱内数据自动保存为PNG图片，并下载到客户本机
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825766bd2c9c.png)

#### **1.10 测点切换**

进入诊断视图后，点击视图切换右侧的测点下拉列表，切换至指定测点
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68257675702df.png)

#### **1.11 时间选择**

进入诊断视图后，点击视图切换右侧的时间选择按钮，弹出时间选择页面
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825768086329.png)

#### **1.12 图谱缩放**

进入诊断视图后，在图谱内使用滚轮可进行图谱放大或缩小。同时使用图谱下放的缩放条可讲图谱缩放至指定大小，左右拖拽缩放条可快速平移图谱位置。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825768f62186.png)

#### **1.13 多点标注**

进入诊断视图后，在波形、频谱可进行多点标注。用户点击按钮开启该功能，开启后在图谱上通过crtl+鼠标左键即可对一个点位进行标注，标注点内可现实其具体数值，最多可支持5个点位同时标注
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68257699e412b.png)

#### **1.14 瀑布视图**

进入诊断视图后，用户点击瀑布分析即可跳转至瀑布视图。进入视图后，点击滑块即可切换数据展示类型。在趋势图内通过crtl+鼠标左键即可对一个点位进行选择，最多可支持5个点位同时标注
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682576a5aa002.png)

#### **1.15 多测点对比**

进入诊断视图后，用户点击多测点对比即可跳转至多测点对比视图。进入视图后，点击滑块即可切换数据展示类型。在测点下拉列表点击即可完成测点的选择和取消。选择完成后趋势图内将显示各选择数据的相关趋势数据，最多支持5个测点进行对比

![](images/image106.png)

在趋势图内，点击某一趋势点，即可在下方出现该选择点位对应的各测点波形、频谱图
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682576b18fd18.png)

#### **1.16 单测点对比**

进入诊断视图后，用户点击单侧点分析即可跳转至单测点分析视图。进入视图后，点击滑块即可切换数据展示类型。在趋势图内通过crtl+鼠标左键即可对一个点位进行选择，最多可支持5个点位同时标注，选择后，下方出现点击时间点
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682576bab4185.png)

#### **1.17 特征趋势分析**

进入诊断视图后，用户点击特征趋势分析即可跳转至特征趋势分析视图。进入视图后，点击测点下拉测点列表即可切换不同采集特征趋势显示，下方出现点击时间点
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682576c68cb5f.png)

### **2.智能看护报告管理**

#### **2.1 导航路径**

「智能机组诊断」→「智能看护报告管理」
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682576d4c3c4d.png)

#### **2.2 功能概述**

管理和查询智能看护报告，帮助用户高效地获取和分析相关数据。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682576e61d589.png)

#### **2.3 下载**

点击报告后方的下载按钮可以下载智能看护报告管理
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682576f3a816a.png)
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682576ff9a521.png)

### **3.异常管理**

#### **3.1 导航路径**

「智能机组诊断」→「异常管理」
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825770a0e19d.png)

#### **3.2功能概述**

用户可以实时监控和管理生产过程中的异常情况，及时采取措施，确保生产的安全和效率。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825771391393.png)

#### **3.3 异常内容**

点击异常内容可以跳转至相应的诊断视图
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825771ce9224.png)

#### **3.4 人工修正**

点击相应的异常后方的人工修正按钮可以手动将异常标记为正常
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68257725b9a66.png)

### **4.智能看护硬件管理**

#### **4.1 导航路径**

「智能机组诊断」→「智能看护硬件管理」
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e6458d743.png)


#### **4.2 功能概述**

监控和管理智能看护硬件的状态，确保设备的正常运行和维护
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e65115dc3.png)


#### **4.3 电池更换**

更换电池后点击电池更换按钮可重置电量，电量将显示为
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e65bb5beb.png)

#### 4.4 通讯状态

通讯状态分为正常、延迟、离线。
正常：传感器波形数据按照设置的上数频率上数即为正常
延迟：传感器波形数据大于等于两个设定上数频率未上数即为延迟
离线：传感器波形数据大于等于10个设定上数频率未上数即为离线

![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e67f21206.png)

## 智能报表管理

### **1.机组运行时间统计报表**

#### **1.1 导航路径**

「智能报表管理」→「机组运行时间统计报表」
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68257756d5cd6.png)

#### **1.2 功能概述**

监控和统计机组的运行时间及其他相关数据，帮助用户了解机组的运行状况，进行有效的管理和维护
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825775f79f9f.png)

#### **1.3 数据导出**

进入报表后，点击右上角的导出按钮即可完成当前显示数据的导出。导出格式为xls，文件名称为：机组运行时间统计报表
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68257767c0212.png)

### **2.机组看护预警统计报表**

#### **2.1 导航路径**

「智能报表管理」→「机组看护预警统计报表」
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682577702562f.png)

#### **2.2 功能概述**

监控和管理机组的运行状态，通过统计各种预警次数，帮助用户及时发现和处理潜在问题，确保机组的正常运行和维护。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825777a91f56.png)

#### **2.3 数据导出**

进入报表后，点击右上角的导出按钮即可完成当前显示数据的导出。导出格式为xls，文件名称为：机组看护预警统计报表
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825778c5d873.png)

## 系统管理**

### **1.消息中心**

#### **1.1 导航路径**

「系统管理」→「消息中心」
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825779e44b35.png)

#### **1.2 功能概述**

在消息中心可以对系统通知进行详尽的查看，并且可以根据用户需求设置通知的频率、方式以及通知的机组范围。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682577a8afc50.png)

#### **1.3 消息列表**

消息中心可以查看当前用户可以接收到的系统消息，用户可以选择查看不同阅读状态的消息
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682577b1752e2.png)

#### **1.4 消息设置**

点击右上角「设置」按钮即可对接收的四类消息进行通知周期以及接收方式设置。各类型消息通知周期包含：「发生时接收同样内容的预警信息」、「发生时不接收同样内容的预警信息」、「每一天」、「每三天」四种通知周期。每日9时向用户发送系统消息。
注：发生时接收同样内容的预警信息：发生任何一种类型的预警及时推送
    发生时不接收同样内容的预警信息：同类型预警内容变化时再进行消息推送
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e6b28a389.png)


而在设置消息接收方式上，用户可设置为仅消息、消息+短信+邮件以及不接收三种
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68a6e6bd1e446.png)


**消息展示**
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682577f64cc43.png)

**邮件展示（需接入邮件服务器）**
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825780157795.png)

**短信展示（本地部署不支持）**
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825780a9f7b2.png)

#### **1.5 消息数量总览**

进入系统后，用户设置看护机组并开启消息接收后，便可接收当前系统推送的启停变化、健康等级、工况预警、门限预警消息。用户可通过用户头像旁的消息助手查看当前各类型未读消息数量，点击即可跳转至消息管理页面，查看该类型未读消息。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682578199767d.png)

#### **1.6 查看/已读**

进入消息中心后，用户选择指定消息后，点击「查看」按钮，弹出消息详情
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825782690c07.png)

点击「已读」按钮，可将消息阅读状态改为已读
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825782f14344.png)

### **2.组织管理**

#### **2.1 导航路径**

「系统管理」→「消息中心」
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68257838bc553.png)

#### **2.2 功能概述**

组织管理可以对管辖组织进行添加及删除。可依据组织层级树挪动组织位置。同一个父级组织下，子组织名称不允许重复。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682578411c2d6.png)

#### **2.3 组织添加**

进入组织管理后，点击右上方的「添加组织」按钮后弹出添加组织页面
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825784b06ded.png)

同一组织下的子组织名称唯一，不允许重复。

#### **2.4 组织编辑**

进入组织管理后，点击指定组织的「编辑」按钮后弹出编辑组织页面
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682578596931c.png)

同一组织下的子组织名称唯一，不允许重复。

#### **2.5 组态地址编辑**

进入组织管理后，点击指定组织的「编辑」按钮后弹出编辑组织页面，在“组态展示链接”内输入Instaguard组态编辑平台绘制的组态图或第三方组态地址。完成后保存。保存成功后，在工艺组态页面内即可看到实时组态
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68257866057de.png)

### **3.角色管理**

#### **3.1 导航路径**

「系统管理」→「角色管理」
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/68257870f2519.png)

#### **3.2 角色添加**

进入组织管理后，点击右上方的「添加组织」按钮后弹出添加角色页面
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825787f533fb.png)

添加时，角色归属于左侧所选择的组织机构，同一组织下的角色名称唯一，不允许重复。客户可自行选择该角色可查看的功能页面及可使用的功能按钮。

#### **3.3 角色编辑**

进入角色管理后，点击指定角色的「编辑」按钮后弹出编辑组织页面
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/6825788a49981.png)

同一组织下的角色名称唯一，不允许重复。客户可自行选择该角色可查看的功能页面及可使用的功能按钮。


### **4.用户管理**

#### **4.1 导航路径**

「系统管理」→「用户管理」
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682578973c284.png)

#### **4.2 用户添加**

进入用户管理后，点击右上方的「添加用户」按钮后弹出添加用户页面
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682578a0d97e9.png)

添加时，用户的登录账号全网唯一，长度至少大于8位。保存后弹出添加用户密码，客户管理员可自行将用户名及密码告知相关人员
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682578af2db70.png)
#### **4.3 重置密码**

进入用户管理后，点击指定用户的「重置密码」按钮后弹出编辑确认页面
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682578bb86090.png)

#### **4.4 停用账户**

进入用户管理后，对于状态处于“启用”的账号，点击「停用账户」按钮后账户变为“停用”状态
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682578c331811.png)

#### **4.5 启用账户**

进入用户管理后，对于状态处于“停用”的账号，点击「启用账户」按钮后账户变为“启用”状态。
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682578cdcea16.png)

#### **4.6 看护机组设置**

进入用户管理后，用户可点击看护机组按钮进行当前用户接收机组消息范围设置。点击后弹出看护机组设置窗体，用户点击输入机组名称、选择组织快速查询机组。也可通过仅显示看护机组滑块快速切换当前用户已经看护机组
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682578d89c9c1.png)
![](https://resource.helplook.net/docker_production/3648ne/article/LqSzZnMl/682578e22ce37.png)